capture log close
prog drop _all
set more off
set trace off
pause on
#delimit ;
clear;

global dir "D:\RA\Moffitt\Nicole_LS\091712";
use "$dir\Data\data1970to2011byGender.dta";

gen str employedlab="Population" if year==2001;
gen str empMenlab="Men" if year==2001;
gen str empWomenlab="Women" if year==2001;

graph twoway 
	(connect men year, ms(i) mlabel(empMenlab) mlabposition(2))
	(connect women year, ms(i) mlabel(empWomenlab) mlabposition(2))
	(connect population year, ms(i) mlabel(employedlab) mlabposition(2)),
	title("Figure 1: Employment to Population Ratio, 1970-2011")
	subtitle("U.S. Civilian Noninstitutional Population ages 16-64", size(medium))
	ytitle("Employment to Population Ratio")
	xtitle("Year")
	xline(2007, lwidth(vthin) lcolor(black) lpattern(shortdash))
	xline(2000, lwidth(vthin) lcolor(black) lpattern(shortdash))
	legend(off)
	xlabel(1970 1980 1990 2000 2007 2011);
graph export "$dir\HistoricalbyGender.eps", replace;

